<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output encoding="us-ascii" indent="yes"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Notice to Mariners</title>
				<style>
					body,  table {font-family:Times New Roman; font-size:10pt}
					table.tableNM {font-weight: bold; margin-bottom:5px}
					div.padLeft {padding-left:20px}
					ol { margin-top:2px; padding-top:2px} 
				</style>
			</head>
			<body>
				<xsl:apply-templates select="annual/geographical_section/temporary | annual/geographical_section/preliminary"/>
				<p><b>CAUTION: This information is not intended to comply with the carriage requirements for Notices to Mariners within Regulation 19.2.1.4 of Chapter V of the Safety of Life at Sea (SOLAS) Convention and may contain differences in format to the Notices published in the Admiralty Notices to Mariners weekly bulletins, which contain the sole authentic text and should always be consulted.</b></p>				
			</body>
		</html>
	</xsl:template>
	<xsl:template match="temporary | preliminary">
		<xsl:variable name="nm_number">
			<xsl:value-of select="@nm_number"/>
			<xsl:if test="name(.) = 'temporary'">
				<xsl:text>(T)</xsl:text>
			</xsl:if>
			<xsl:if test="name(.) = 'preliminary'">
				<xsl:text>(P)</xsl:text>
			</xsl:if>
			<xsl:text>/</xsl:text>
			<xsl:value-of select="@year"/>
		</xsl:variable>
		<div class="padLeft">
			<table class="tableNM" width="100%" border="0">
				<tbody>
					<tr>
						<td width="90px" valign="top">
							<xsl:copy-of select="$nm_number"/>&#160;</td>
						<td valign="top">
							<xsl:value-of select="region"/>
							<xsl:if test="sub_region">
								<xsl:text> - </xsl:text>
								<xsl:value-of select="sub_region"/>
							</xsl:if>
							<xsl:if test="vicinities">
								<xsl:apply-templates select="vicinities"/>
							</xsl:if>
							<xsl:if test="feature_types">
								<xsl:text> -</xsl:text>
								<xsl:apply-templates select="feature_types"/>
							</xsl:if>
						</td>
					</tr>
				</tbody>
			</table>
			<xsl:text>Source: </xsl:text>
			<xsl:value-of select="authority"/>
		</div>
		<xsl:apply-templates select="ordered_list"/>
		<div class="padLeft">
			<xsl:variable name="cPrefix">
				<xsl:value-of select="chart_numbers/chart_number/prefix"/>
			</xsl:variable>
			<xsl:if test="$cPrefix != 'none'">
				<b>
					<xsl:text>Charts affected</xsl:text>
					<xsl:apply-templates select="chart_numbers"/>
				</b>
				<p/>
			</xsl:if>
			<xsl:if test="graphic">
				<xsl:apply-templates select="graphic"/>
				<p/>
			</xsl:if>
		</div>
	</xsl:template>
	
	<xsl:template match="vicinities">
		<xsl:for-each select="vicinity">
			<xsl:text> - </xsl:text>
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="feature_types">
		<xsl:apply-templates select="feature_type"/>
	</xsl:template>
	<xsl:template match="feature_type">
		<xsl:text> </xsl:text>
		<xsl:value-of select="."/>
		<xsl:text>.</xsl:text>
	</xsl:template>
	
	<xsl:template match="ordered_list">
		<xsl:choose>
			<xsl:when test="./@Style != 'Arabic'">
				<ol style="list-style-type: lower-alpha">
					<xsl:apply-templates select="list_item"/>
				</ol>
			</xsl:when>
			<xsl:otherwise>
				<ol style="list-style-type: decimal">
					<xsl:apply-templates select="list_item"/>
				</ol>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="list_item">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="list_item/paragraph">
		<xsl:if test="string-length(.) &gt; 0">
			<xsl:choose>
				<xsl:when test="name(preceding-sibling::*[1]) = 'paragraph'">
					<br/>
					<xsl:apply-templates/>
				</xsl:when>
				<xsl:when test="name(preceding-sibling::*[1]) = 'TABLE'">
					<xsl:apply-templates/>
				</xsl:when>
				<xsl:otherwise>
					<li>
						<xsl:apply-templates/>
					</li>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="TABLE">
		<p/>
		<TABLE width="100%" border="0">
			<xsl:apply-templates/>
		</TABLE>
	</xsl:template>
	
	<xsl:template match="TBODY | TR |TD">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="subscript">
		<sub>
			<xsl:apply-templates/>
		</sub>
	</xsl:template>
	
	<xsl:template match="emphasis">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	
	<xsl:template match="strong">
		<b>
			<xsl:apply-templates/>
		</b>
	</xsl:template>
	
	<xsl:template match="underscore">
		<u>
			<xsl:apply-templates/>
		</u>
	</xsl:template>
	
	<xsl:template match="location">
		<xsl:apply-templates select="latitude"/>
		<xsl:if test="latitude and longitude">
			<xsl:text>,&#160;</xsl:text>
		</xsl:if>
		<xsl:apply-templates select="longitude"/>
	</xsl:template>
	
	<xsl:template match="latitude | longitude">
		<xsl:value-of select="degrees"/>
		<xsl:text>&#176;&#160;</xsl:text>
		<xsl:value-of select="minutes"/>
		<xsl:text>&#180;</xsl:text>
		<xsl:choose>
			<xsl:when test="decimals">
				<xsl:text>&#183;</xsl:text>
				<xsl:value-of select="decimals"/>
			</xsl:when>
			<xsl:when test="seconds">
				<xsl:text>&#160;</xsl:text>
				<xsl:value-of select="seconds"/>
				<xsl:text>"</xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:value-of select="hemisphere"/>
		<xsl:text>.</xsl:text>
	</xsl:template>
	
	<xsl:template match="chart_numbers">
		<xsl:apply-templates select="chart_number"/>
	</xsl:template>
	
	<xsl:template match="chart_number">
		&#x2014; <xsl:value-of select="prefix"/>
		<xsl:value-of select="infix"/>
		<xsl:value-of select="suffix"/>
	</xsl:template>
	
	<xsl:template match="graphic">
		<xsl:text>The diagram for this NM can be seen on http://www.nmwebsearch.com 
		or can be found on the AVCS Update Disk as </xsl:text>
		<xsl:call-template name="substring-after-last">
			<xsl:with-param name="string" select="substring-after(@file_spec, '\')"/>
		</xsl:call-template>
		<xsl:text> in \INFO\ADC\TPNM Diagrams.zip</xsl:text>
	</xsl:template>
	
	<xsl:template name="substring-after-last">
		<xsl:param name="string"/>
		<xsl:choose>
			<xsl:when test="contains($string, '\')">
				<xsl:call-template name="substring-after-last">
					<xsl:with-param name="string" select="substring-after($string, '\')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
